/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.util.struct;

import com.t2pellet.strawgolem.util.struct.OctBox;
import com.t2pellet.strawgolem.util.struct.PosTree;
import com.t2pellet.strawgolem.util.struct.Triplet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Stack;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

public class OctTree
implements PosTree {
    private static final OctBox DEFAULT = new OctBox(-2147483645, -2147483645, -2147483645, 0x7FFFFFFD, 0x7FFFFFFD, 0x7FFFFFFD);
    private static final HashMap<Triplet<Boolean, Boolean, Boolean>, Octant> octants = new HashMap();
    private final OctTree parent;
    private final OctBox boundary;
    private final class_2382 center;
    private final HashMap<Octant, OctTree> octTrees = new HashMap();
    private class_2338 point;

    OctTree() {
        this.parent = null;
        this.boundary = DEFAULT;
        this.center = class_2338.field_10980;
        this.buildMaps();
    }

    public OctTree(OctTree parent, Octant octant) {
        this.parent = parent;
        switch (octant) {
            case FIRST: {
                this.boundary = new OctBox(parent.boundary.minX, parent.boundary.minY, parent.boundary.minZ, parent.center.method_10263(), parent.center.method_10264(), parent.center.method_10260());
                break;
            }
            case SECOND: {
                this.boundary = new OctBox(parent.boundary.minX, parent.boundary.minY, parent.center.method_10260(), parent.center.method_10263(), parent.center.method_10264(), parent.boundary.maxZ);
                break;
            }
            case THIRD: {
                this.boundary = new OctBox(parent.center.method_10263(), parent.boundary.minY, parent.boundary.minZ, parent.boundary.maxX, parent.center.method_10264(), parent.center.method_10260());
                break;
            }
            case FOURTH: {
                this.boundary = new OctBox(parent.center.method_10263(), parent.boundary.minY, parent.center.method_10260(), parent.boundary.maxX, parent.center.method_10264(), parent.boundary.maxZ);
                break;
            }
            case FIFTH: {
                this.boundary = new OctBox(parent.boundary.minX, parent.center.method_10264(), parent.boundary.minZ, parent.center.method_10263(), parent.boundary.maxY, parent.center.method_10260());
                break;
            }
            case SIXTH: {
                this.boundary = new OctBox(parent.boundary.minX, parent.center.method_10264(), parent.center.method_10260(), parent.center.method_10263(), parent.boundary.maxY, parent.boundary.maxZ);
                break;
            }
            case SEVENTH: {
                this.boundary = new OctBox(parent.center.method_10263(), parent.center.method_10264(), parent.boundary.minZ, parent.boundary.maxX, parent.boundary.maxY, parent.center.method_10260());
                break;
            }
            default: {
                this.boundary = new OctBox(parent.center.method_10263(), parent.center.method_10264(), parent.center.method_10260(), parent.boundary.maxX, parent.boundary.maxY, parent.boundary.maxZ);
            }
        }
        this.center = this.boundary.center;
        this.buildMaps();
    }

    @Override
    public void insert(class_2338 pos) {
        if (pos == null) {
            return;
        }
        OctTree result = this.search(pos);
        if (pos.equals((Object)result.point)) {
            return;
        }
        if (result.isEmpty()) {
            result.point = pos;
        } else if (result.isLeaf()) {
            result.insertToLeaf(pos);
        } else {
            Octant posOctant = result.getOctant(pos);
            OctTree posTree = new OctTree(result, posOctant);
            posTree.point = pos;
            result.setOctTree(posOctant, posTree);
        }
    }

    @Override
    public void delete(class_2338 pos) {
        if (pos == null) {
            return;
        }
        OctTree result = this.search(pos);
        if (pos.equals((Object)result.point)) {
            result.point = null;
            while (result.parent != null && result.isEmpty()) {
                Octant octant = result.parent.getOctant(pos);
                result.parent.setOctTree(octant, null);
                result = result.parent;
            }
        }
    }

    @Override
    public class_2338 findNearest(class_2338 pos) {
        if (this.isEmpty()) {
            return null;
        }
        OctTree closestTree = this.search(pos);
        if (pos.equals((Object)closestTree.point)) {
            return pos;
        }
        PriorityQueue<class_2338> closestPQ = new PriorityQueue<class_2338>((o1, o2) -> Float.compare(o1.method_19455((class_2382)pos), o2.method_19455((class_2382)pos)));
        closestTree.buildPQ(closestPQ);
        return closestPQ.poll();
    }

    private void buildPQ(PriorityQueue<class_2338> pq) {
        if (this.isLeaf()) {
            pq.offer(this.point);
        } else {
            for (Octant octant : Octant.values()) {
                OctTree child = this.getOctTree(octant);
                if (child == null) continue;
                child.buildPQ(pq);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.isLeaf() && this.point == null;
    }

    @Override
    public Iterator<class_2338> iterator() {
        return new TreeIterator(this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OctTree)) {
            return false;
        }
        OctTree tree = (OctTree)obj;
        return this.boundary.equals(tree.boundary);
    }

    private void buildMaps() {
        this.octTrees.put(Octant.FIRST, null);
        this.octTrees.put(Octant.SECOND, null);
        this.octTrees.put(Octant.THIRD, null);
        this.octTrees.put(Octant.FOURTH, null);
        this.octTrees.put(Octant.FIFTH, null);
        this.octTrees.put(Octant.SIXTH, null);
        this.octTrees.put(Octant.SEVENTH, null);
        this.octTrees.put(Octant.EIGHTH, null);
    }

    private Octant getOctant(class_2338 query) {
        Triplet<Boolean, Boolean, Boolean> queryValues = new Triplet<Boolean, Boolean, Boolean>(query.method_10263() < this.center.method_10263(), query.method_10264() < this.center.method_10264(), query.method_10260() < this.center.method_10260());
        return octants.get(queryValues);
    }

    private OctTree getOctTree(Octant query) {
        return this.octTrees.get((Object)query);
    }

    private OctTree getOctTree(class_2338 query) {
        return this.getOctTree(this.getOctant(query));
    }

    private void setOctTree(Octant key, OctTree value) {
        this.octTrees.put(key, value);
    }

    private boolean isLeaf() {
        return this.octTrees.values().stream().allMatch(Objects::isNull);
    }

    private OctTree search(class_2338 pos) {
        if (pos.equals((Object)this.point)) {
            return this;
        }
        OctTree octTree = this.getOctTree(pos);
        if (octTree != null) {
            return octTree.search(pos);
        }
        return this;
    }

    private void insertToLeaf(class_2338 pos) {
        OctTree tree = this;
        Octant pointOctant = tree.getOctant(this.point);
        Octant posOctant = tree.getOctant(pos);
        while (pointOctant == posOctant) {
            tree.setOctTree(pointOctant, new OctTree(tree, pointOctant));
            tree = tree.getOctTree(pointOctant);
            pointOctant = tree.getOctant(this.point);
            posOctant = tree.getOctant(pos);
        }
        OctTree posTree = new OctTree(tree, posOctant);
        posTree.point = pos;
        tree.setOctTree(posOctant, posTree);
        OctTree pointTree = new OctTree(tree, pointOctant);
        pointTree.point = this.point;
        tree.setOctTree(pointOctant, pointTree);
        this.point = null;
    }

    static {
        octants.put(new Triplet<Boolean, Boolean, Boolean>(true, true, true), Octant.FIRST);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(true, true, false), Octant.SECOND);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(false, true, true), Octant.THIRD);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(false, true, false), Octant.FOURTH);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(true, false, true), Octant.FIFTH);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(true, false, false), Octant.SIXTH);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(false, false, true), Octant.SEVENTH);
        octants.put(new Triplet<Boolean, Boolean, Boolean>(false, false, false), Octant.EIGHTH);
    }

    private static enum Octant {
        FIRST,
        SECOND,
        THIRD,
        FOURTH,
        FIFTH,
        SIXTH,
        SEVENTH,
        EIGHTH;

    }

    private static class TreeIterator
    implements Iterator<class_2338> {
        private final Stack<class_2338> positions = new Stack();

        private TreeIterator(OctTree tree) {
            this.buildStack(tree);
        }

        @Override
        public boolean hasNext() {
            return !this.positions.isEmpty();
        }

        @Override
        public class_2338 next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.positions.pop();
        }

        private void buildStack(OctTree parent) {
            for (OctTree tree : parent.octTrees.values()) {
                if (tree == null) continue;
                if (tree.point != null) {
                    this.positions.push(tree.point);
                    continue;
                }
                this.buildStack(tree);
            }
        }
    }
}

